/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo.dependencies;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Named
@Singleton
public class RepositoryUtils {
    private final ProjectBuilder projectBuilder;
    private final RepositorySystem repositorySystem;
    private final Provider<MavenSession> sessionProvider;

    @Inject
    public RepositoryUtils(ProjectBuilder projectBuilder, RepositorySystem repositorySystem, Provider<MavenSession> sessionProvider) {
        this.projectBuilder = projectBuilder;
        this.repositorySystem = repositorySystem;
        this.sessionProvider = sessionProvider;
    }

    public void resolve(Artifact artifact) throws ArtifactResolutionException {
        MavenSession session = this.sessionProvider.get();
        MavenProject project = session.getCurrentProject();
        ArtifactRequest request = new ArtifactRequest(org.apache.maven.RepositoryUtils.toArtifact((Artifact)artifact), project.getRemoteProjectRepositories(), null);
        ArtifactResult result = this.repositorySystem.resolveArtifact(session.getRepositorySession(), request);
        artifact.setFile(result.getArtifact().getFile());
        artifact.setResolved(true);
    }

    public MavenProject getMavenProjectFromRepository(Artifact artifact) throws ProjectBuildingException {
        boolean allowStubModel = false;
        if (!"pom".equals(artifact.getType())) {
            allowStubModel = true;
        }
        MavenSession session = this.sessionProvider.get();
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(session.getCurrentProject().getRemoteArtifactRepositories());
        buildingRequest.setProcessPlugins(false);
        return this.projectBuilder.build(artifact, allowStubModel, (ProjectBuildingRequest)buildingRequest).getProject();
    }
}

