/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.apache.maven.doxia.sink.Sink;

public class EventCapturingSinkProxy
implements InvocationHandler {
    private final Sink sink;
    private final List<String> capturedEventNames;

    public static Sink newInstance(Sink sink, List<String> capturedEventNames) {
        return (Sink)Proxy.newProxyInstance(sink.getClass().getClassLoader(), new Class[]{Sink.class}, (InvocationHandler)new EventCapturingSinkProxy(sink, capturedEventNames));
    }

    private EventCapturingSinkProxy(Sink sink, List<String> capturedEventNames) {
        this.sink = sink;
        this.capturedEventNames = capturedEventNames;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        try {
            this.capturedEventNames.add(method.getName());
            result = method.invoke((Object)this.sink, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return result;
    }
}

