/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionListObserver;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.util.ByteSequence;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.stream.Streams;

public class InstructionList
implements Iterable<InstructionHandle> {
    private InstructionHandle start;
    private InstructionHandle end;
    private int length;
    private int[] bytePositions;
    private List<InstructionListObserver> observers;

    public static InstructionHandle findHandle(InstructionHandle[] ihs, int[] pos, int count, int target) {
        if (ihs != null && pos != null) {
            int l = 0;
            int r = count - 1;
            do {
                int i2;
                int j;
                if ((j = pos[i2 = l + r >>> 1]) == target) {
                    return ihs[i2];
                }
                if (target < j) {
                    r = i2 - 1;
                    continue;
                }
                l = i2 + 1;
            } while (l <= r);
        }
        return null;
    }

    public InstructionList() {
    }

    public InstructionList(BranchInstruction i2) {
        this.append(i2);
    }

    public InstructionList(byte[] code) {
        InstructionHandle ih;
        int[] pos;
        InstructionHandle[] ihs;
        int count = 0;
        try (ByteSequence bytes = new ByteSequence(code);){
            ihs = new InstructionHandle[code.length];
            pos = new int[code.length];
            while (bytes.available() > 0) {
                int off;
                pos[count] = off = bytes.getIndex();
                Instruction i2 = Instruction.readInstruction(bytes);
                ih = i2 instanceof BranchInstruction ? this.append((BranchInstruction)i2) : this.append(i2);
                ih.setPosition(off);
                ihs[count] = ih;
                ++count;
            }
        }
        catch (IOException e) {
            throw new ClassGenException(e.toString(), e);
        }
        this.bytePositions = Arrays.copyOf(pos, count);
        for (int i3 = 0; i3 < count; ++i3) {
            if (!(ihs[i3] instanceof BranchHandle)) continue;
            BranchInstruction bi = (BranchInstruction)ihs[i3].getInstruction();
            int target = bi.getPosition() + bi.getIndex();
            ih = InstructionList.findHandle(ihs, pos, count, target);
            if (ih == null) {
                throw new ClassGenException("Couldn't find target for branch: " + bi);
            }
            bi.setTarget(ih);
            if (!(bi instanceof Select)) continue;
            Select s = (Select)bi;
            int[] indices = s.getIndices();
            for (int j = 0; j < indices.length; ++j) {
                target = bi.getPosition() + indices[j];
                ih = InstructionList.findHandle(ihs, pos, count, target);
                if (ih == null) {
                    throw new ClassGenException("Couldn't find target for switch: " + bi);
                }
                s.setTarget(j, ih);
            }
        }
    }

    public InstructionList(CompoundInstruction c) {
        this.append(c.getInstructionList());
    }

    public InstructionList(Instruction i2) {
        this.append(i2);
    }

    public void addObserver(InstructionListObserver o) {
        if (this.observers == null) {
            this.observers = new ArrayList<InstructionListObserver>();
        }
        this.observers.add(o);
    }

    public BranchHandle append(BranchInstruction i2) {
        BranchHandle ih = BranchHandle.getBranchHandle(i2);
        this.append(ih);
        return ih;
    }

    public InstructionHandle append(CompoundInstruction c) {
        return this.append(c.getInstructionList());
    }

    public InstructionHandle append(Instruction i2) {
        InstructionHandle ih = InstructionHandle.getInstructionHandle(i2);
        this.append(ih);
        return ih;
    }

    public InstructionHandle append(Instruction i2, CompoundInstruction c) {
        return this.append(i2, c.getInstructionList());
    }

    public InstructionHandle append(Instruction i2, Instruction j) {
        return this.append(i2, new InstructionList(j));
    }

    public InstructionHandle append(Instruction i2, InstructionList il) {
        InstructionHandle ih = this.findInstruction2(i2);
        if (ih == null) {
            throw new ClassGenException("Instruction " + i2 + " is not contained in this list.");
        }
        return this.append(ih, il);
    }

    private void append(InstructionHandle ih) {
        if (this.isEmpty()) {
            this.start = this.end = ih;
            ih.setNext(ih.setPrev(null));
        } else {
            this.end.setNext(ih);
            ih.setPrev(this.end);
            ih.setNext(null);
            this.end = ih;
        }
        ++this.length;
    }

    public BranchHandle append(InstructionHandle ih, BranchInstruction i2) {
        BranchHandle bh = BranchHandle.getBranchHandle(i2);
        InstructionList il = new InstructionList();
        il.append(bh);
        this.append(ih, il);
        return bh;
    }

    public InstructionHandle append(InstructionHandle ih, CompoundInstruction c) {
        return this.append(ih, c.getInstructionList());
    }

    public InstructionHandle append(InstructionHandle ih, Instruction i2) {
        return this.append(ih, new InstructionList(i2));
    }

    public InstructionHandle append(InstructionHandle ih, InstructionList il) {
        if (il == null) {
            throw new ClassGenException("Appending null InstructionList");
        }
        if (il.isEmpty()) {
            return ih;
        }
        InstructionHandle next = ih.getNext();
        InstructionHandle ret = il.start;
        ih.setNext(il.start);
        il.start.setPrev(ih);
        il.end.setNext(next);
        if (next != null) {
            next.setPrev(il.end);
        } else {
            this.end = il.end;
        }
        this.length += il.length;
        il.clear();
        return ret;
    }

    public InstructionHandle append(InstructionList il) {
        if (il == null) {
            throw new ClassGenException("Appending null InstructionList");
        }
        if (il.isEmpty()) {
            return null;
        }
        if (this.isEmpty()) {
            this.start = il.start;
            this.end = il.end;
            this.length = il.length;
            il.clear();
            return this.start;
        }
        return this.append(this.end, il);
    }

    private void clear() {
        this.end = null;
        this.start = null;
        this.length = 0;
    }

    public boolean contains(Instruction i2) {
        return this.findInstruction1(i2) != null;
    }

    public boolean contains(InstructionHandle i2) {
        if (i2 == null) {
            return false;
        }
        for (InstructionHandle ih = this.start; ih != null; ih = ih.getNext()) {
            if (ih != i2) continue;
            return true;
        }
        return false;
    }

    public InstructionList copy() {
        InstructionHandle ih;
        HashMap<InstructionHandle, InstructionHandle> map = new HashMap<InstructionHandle, InstructionHandle>();
        InstructionList il = new InstructionList();
        for (ih = this.start; ih != null; ih = ih.getNext()) {
            Instruction i2 = ih.getInstruction();
            Instruction c = i2.copy();
            if (c instanceof BranchInstruction) {
                map.put(ih, il.append((BranchInstruction)c));
                continue;
            }
            map.put(ih, il.append(c));
        }
        ih = this.start;
        InstructionHandle ch = il.start;
        while (ih != null) {
            Instruction i3 = ih.getInstruction();
            Instruction c = ch.getInstruction();
            if (i3 instanceof BranchInstruction) {
                BranchInstruction bi = (BranchInstruction)i3;
                BranchInstruction bc = (BranchInstruction)c;
                InstructionHandle itarget = bi.getTarget();
                bc.setTarget((InstructionHandle)map.get(itarget));
                if (bi instanceof Select) {
                    InstructionHandle[] itargets = ((Select)bi).getTargets();
                    InstructionHandle[] ctargets = ((Select)bc).getTargets();
                    for (int j = 0; j < itargets.length; ++j) {
                        ctargets[j] = (InstructionHandle)map.get(itargets[j]);
                    }
                }
            }
            ih = ih.getNext();
            ch = ch.getNext();
        }
        return il;
    }

    public void delete(Instruction i2) throws TargetLostException {
        InstructionHandle ih = this.findInstruction1(i2);
        if (ih == null) {
            throw new ClassGenException("Instruction " + i2 + " is not contained in this list.");
        }
        this.delete(ih);
    }

    public void delete(Instruction from, Instruction to) throws TargetLostException {
        InstructionHandle fromIh = this.findInstruction1(from);
        if (fromIh == null) {
            throw new ClassGenException("Instruction " + from + " is not contained in this list.");
        }
        InstructionHandle toIh = this.findInstruction2(to);
        if (toIh == null) {
            throw new ClassGenException("Instruction " + to + " is not contained in this list.");
        }
        this.delete(fromIh, toIh);
    }

    public void delete(InstructionHandle ih) throws TargetLostException {
        this.remove(ih.getPrev(), ih.getNext());
    }

    public void delete(InstructionHandle from, InstructionHandle to) throws TargetLostException {
        this.remove(from.getPrev(), to.getNext());
    }

    public void dispose() {
        for (InstructionHandle ih = this.end; ih != null; ih = ih.getPrev()) {
            ih.dispose();
        }
        this.clear();
    }

    public InstructionHandle findHandle(int pos) {
        int[] positions = this.bytePositions;
        InstructionHandle ih = this.start;
        for (int i2 = 0; i2 < this.length; ++i2) {
            if (positions[i2] == pos) {
                return ih;
            }
            ih = ih.getNext();
        }
        return null;
    }

    private InstructionHandle findInstruction1(Instruction i2) {
        for (InstructionHandle ih = this.start; ih != null; ih = ih.getNext()) {
            if (ih.getInstruction() != i2) continue;
            return ih;
        }
        return null;
    }

    private InstructionHandle findInstruction2(Instruction i2) {
        for (InstructionHandle ih = this.end; ih != null; ih = ih.getPrev()) {
            if (ih.getInstruction() != i2) continue;
            return ih;
        }
        return null;
    }

    public byte[] getByteCode() {
        this.setPositions();
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            for (InstructionHandle ih = this.start; ih != null; ih = ih.getNext()) {
                Instruction i2 = ih.getInstruction();
                i2.dump(out);
            }
            out.flush();
        }
        catch (IOException e) {
            System.err.println(e);
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        return b.toByteArray();
    }

    public InstructionHandle getEnd() {
        return this.end;
    }

    public InstructionHandle[] getInstructionHandles() {
        InstructionHandle[] ihs = new InstructionHandle[this.length];
        InstructionHandle ih = this.start;
        for (int i2 = 0; i2 < this.length; ++i2) {
            ihs[i2] = ih;
            ih = ih.getNext();
        }
        return ihs;
    }

    public int[] getInstructionPositions() {
        return this.bytePositions;
    }

    public Instruction[] getInstructions() {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        try (ByteSequence bytes = new ByteSequence(this.getByteCode());){
            while (bytes.available() > 0) {
                instructions.add(Instruction.readInstruction(bytes));
            }
        }
        catch (IOException e) {
            throw new ClassGenException(e.toString(), e);
        }
        return instructions.toArray(Instruction.EMPTY_ARRAY);
    }

    public int getLength() {
        return this.length;
    }

    public InstructionHandle getStart() {
        return this.start;
    }

    public BranchHandle insert(BranchInstruction i2) {
        BranchHandle ih = BranchHandle.getBranchHandle(i2);
        this.insert(ih);
        return ih;
    }

    public InstructionHandle insert(CompoundInstruction c) {
        return this.insert(c.getInstructionList());
    }

    public InstructionHandle insert(Instruction i2) {
        InstructionHandle ih = InstructionHandle.getInstructionHandle(i2);
        this.insert(ih);
        return ih;
    }

    public InstructionHandle insert(Instruction i2, CompoundInstruction c) {
        return this.insert(i2, c.getInstructionList());
    }

    public InstructionHandle insert(Instruction i2, Instruction j) {
        return this.insert(i2, new InstructionList(j));
    }

    public InstructionHandle insert(Instruction i2, InstructionList il) {
        InstructionHandle ih = this.findInstruction1(i2);
        if (ih == null) {
            throw new ClassGenException("Instruction " + i2 + " is not contained in this list.");
        }
        return this.insert(ih, il);
    }

    private void insert(InstructionHandle ih) {
        if (this.isEmpty()) {
            this.start = this.end = ih;
            ih.setNext(ih.setPrev(null));
        } else {
            this.start.setPrev(ih);
            ih.setNext(this.start);
            ih.setPrev(null);
            this.start = ih;
        }
        ++this.length;
    }

    public BranchHandle insert(InstructionHandle ih, BranchInstruction i2) {
        BranchHandle bh = BranchHandle.getBranchHandle(i2);
        InstructionList il = new InstructionList();
        il.append(bh);
        this.insert(ih, il);
        return bh;
    }

    public InstructionHandle insert(InstructionHandle ih, CompoundInstruction c) {
        return this.insert(ih, c.getInstructionList());
    }

    public InstructionHandle insert(InstructionHandle ih, Instruction i2) {
        return this.insert(ih, new InstructionList(i2));
    }

    public InstructionHandle insert(InstructionHandle ih, InstructionList il) {
        if (il == null) {
            throw new ClassGenException("Inserting null InstructionList");
        }
        if (il.isEmpty()) {
            return ih;
        }
        InstructionHandle prev = ih.getPrev();
        InstructionHandle ret = il.start;
        ih.setPrev(il.end);
        il.end.setNext(ih);
        il.start.setPrev(prev);
        if (prev != null) {
            prev.setNext(il.start);
        } else {
            this.start = il.start;
        }
        this.length += il.length;
        il.clear();
        return ret;
    }

    public InstructionHandle insert(InstructionList il) {
        if (this.isEmpty()) {
            this.append(il);
            return this.start;
        }
        return this.insert(this.start, il);
    }

    public boolean isEmpty() {
        return this.start == null;
    }

    @Override
    public Iterator<InstructionHandle> iterator() {
        return new Iterator<InstructionHandle>(){
            private InstructionHandle ih;
            {
                this.ih = InstructionList.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.ih != null;
            }

            @Override
            public InstructionHandle next() throws NoSuchElementException {
                if (this.ih == null) {
                    throw new NoSuchElementException();
                }
                InstructionHandle i2 = this.ih;
                this.ih = this.ih.getNext();
                return i2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void move(InstructionHandle ih, InstructionHandle target) {
        this.move(ih, ih, target);
    }

    public void move(InstructionHandle start, InstructionHandle end, InstructionHandle target) {
        if (start == null || end == null) {
            throw new ClassGenException("Invalid null handle: From " + start + " to " + end);
        }
        if (target == start || target == end) {
            throw new ClassGenException("Invalid range: From " + start + " to " + end + " contains target " + target);
        }
        for (InstructionHandle ih = start; ih != end.getNext(); ih = ih.getNext()) {
            if (ih == null) {
                throw new ClassGenException("Invalid range: From " + start + " to " + end);
            }
            if (ih != target) continue;
            throw new ClassGenException("Invalid range: From " + start + " to " + end + " contains target " + target);
        }
        InstructionHandle prev = start.getPrev();
        InstructionHandle next = end.getNext();
        if (prev != null) {
            prev.setNext(next);
        } else {
            this.start = next;
        }
        if (next != null) {
            next.setPrev(prev);
        } else {
            this.end = prev;
        }
        start.setPrev(end.setNext(null));
        if (target == null) {
            if (this.start != null) {
                this.start.setPrev(end);
            }
            end.setNext(this.start);
            this.start = start;
        } else {
            next = target.getNext();
            target.setNext(start);
            start.setPrev(target);
            end.setNext(next);
            if (next != null) {
                next.setPrev(end);
            } else {
                this.end = end;
            }
        }
    }

    public void redirectBranches(InstructionHandle oldTarget, InstructionHandle newTarget) {
        for (InstructionHandle ih = this.start; ih != null; ih = ih.getNext()) {
            Instruction i2 = ih.getInstruction();
            if (!(i2 instanceof BranchInstruction)) continue;
            BranchInstruction b = (BranchInstruction)i2;
            InstructionHandle target = b.getTarget();
            if (target == oldTarget) {
                b.setTarget(newTarget);
            }
            if (!(b instanceof Select)) continue;
            InstructionHandle[] targets = ((Select)b).getTargets();
            for (int j = 0; j < targets.length; ++j) {
                if (targets[j] != oldTarget) continue;
                ((Select)b).setTarget(j, newTarget);
            }
        }
    }

    public void redirectExceptionHandlers(CodeExceptionGen[] exceptions, InstructionHandle oldTarget, InstructionHandle newTarget) {
        Streams.of((Object[])exceptions).forEach(exception -> {
            if (exception.getStartPC() == oldTarget) {
                exception.setStartPC(newTarget);
            }
            if (exception.getEndPC() == oldTarget) {
                exception.setEndPC(newTarget);
            }
            if (exception.getHandlerPC() == oldTarget) {
                exception.setHandlerPC(newTarget);
            }
        });
    }

    public void redirectLocalVariables(LocalVariableGen[] lg, InstructionHandle oldTarget, InstructionHandle newTarget) {
        Streams.of((Object[])lg).forEach(element -> {
            if (element.getStart() == oldTarget) {
                element.setStart(newTarget);
            }
            if (element.getEnd() == oldTarget) {
                element.setEnd(newTarget);
            }
        });
    }

    private void remove(InstructionHandle prev, InstructionHandle next) throws TargetLostException {
        InstructionHandle last;
        InstructionHandle first;
        if (prev == null && next == null) {
            first = this.start;
            last = this.end;
            this.end = null;
            this.start = null;
        } else {
            if (prev == null) {
                first = this.start;
                this.start = next;
            } else {
                first = prev.getNext();
                prev.setNext(next);
            }
            if (next == null) {
                last = this.end;
                this.end = prev;
            } else {
                last = next.getPrev();
                next.setPrev(prev);
            }
        }
        first.setPrev(null);
        last.setNext(null);
        ArrayList<InstructionHandle> targetList = new ArrayList<InstructionHandle>();
        for (InstructionHandle ih = first; ih != null; ih = ih.getNext()) {
            ih.getInstruction().dispose();
        }
        StringBuilder buf = new StringBuilder("{ ");
        InstructionHandle ih = first;
        while (ih != null) {
            next = ih.getNext();
            --this.length;
            if (ih.hasTargeters()) {
                targetList.add(ih);
                buf.append(ih.toString(true)).append(" ");
                ih.setNext(ih.setPrev(null));
            } else {
                ih.dispose();
            }
            ih = next;
        }
        buf.append("}");
        if (!targetList.isEmpty()) {
            throw new TargetLostException(targetList.toArray(InstructionHandle.EMPTY_ARRAY), buf.toString());
        }
    }

    public void removeObserver(InstructionListObserver o) {
        if (this.observers != null) {
            this.observers.remove(o);
        }
    }

    public void replaceConstantPool(ConstantPoolGen oldCp, ConstantPoolGen newCp) {
        for (InstructionHandle ih = this.start; ih != null; ih = ih.getNext()) {
            Instruction i2 = ih.getInstruction();
            if (!(i2 instanceof CPInstruction)) continue;
            CPInstruction ci = (CPInstruction)i2;
            Constant c = oldCp.getConstant(ci.getIndex());
            ci.setIndex(newCp.addConstant(c, oldCp));
        }
    }

    public void setPositions() {
        this.setPositions(false);
    }

    public void setPositions(boolean check) {
        Instruction i2;
        InstructionHandle ih;
        int maxAdditionalBytes = 0;
        int additionalBytes = 0;
        int index = 0;
        int count = 0;
        int[] pos = new int[this.length];
        if (check) {
            for (ih = this.start; ih != null; ih = ih.getNext()) {
                i2 = ih.getInstruction();
                if (!(i2 instanceof BranchInstruction)) continue;
                Instruction inst = ((BranchInstruction)i2).getTarget().getInstruction();
                if (!this.contains(inst)) {
                    throw new ClassGenException("Branch target of " + Const.getOpcodeName(i2.getOpcode()) + ":" + inst + " not in instruction list");
                }
                if (i2 instanceof Select) {
                    InstructionHandle[] targets;
                    for (InstructionHandle target : targets = ((Select)i2).getTargets()) {
                        inst = target.getInstruction();
                        if (this.contains(inst)) continue;
                        throw new ClassGenException("Branch target of " + Const.getOpcodeName(i2.getOpcode()) + ":" + inst + " not in instruction list");
                    }
                }
                if (ih instanceof BranchHandle) continue;
                throw new ClassGenException("Branch instruction " + Const.getOpcodeName(i2.getOpcode()) + ":" + inst + " not contained in BranchHandle.");
            }
        }
        for (ih = this.start; ih != null; ih = ih.getNext()) {
            i2 = ih.getInstruction();
            ih.setPosition(index);
            pos[count++] = index;
            switch (i2.getOpcode()) {
                case 167: 
                case 168: {
                    maxAdditionalBytes += 2;
                    break;
                }
                case 170: 
                case 171: {
                    maxAdditionalBytes += 3;
                    break;
                }
            }
            index += i2.getLength();
        }
        for (ih = this.start; ih != null; ih = ih.getNext()) {
            additionalBytes += ih.updatePosition(additionalBytes, maxAdditionalBytes);
        }
        count = 0;
        index = 0;
        for (ih = this.start; ih != null; ih = ih.getNext()) {
            i2 = ih.getInstruction();
            ih.setPosition(index);
            pos[count++] = index;
            index += i2.getLength();
        }
        this.bytePositions = Arrays.copyOfRange(pos, 0, count);
    }

    public int size() {
        return this.length;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean verbose) {
        StringBuilder buf = new StringBuilder();
        for (InstructionHandle ih = this.start; ih != null; ih = ih.getNext()) {
            buf.append(ih.toString(verbose)).append("\n");
        }
        return buf.toString();
    }

    public void update() {
        if (this.observers != null) {
            for (InstructionListObserver observer : this.observers) {
                observer.notify(this);
            }
        }
    }
}

