/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport.imap;

import net.messagevortex.transport.imap.ImapCommand;
import net.messagevortex.transport.imap.ImapCommandFactory;
import net.messagevortex.transport.imap.ImapConnection;
import net.messagevortex.transport.imap.ImapException;
import net.messagevortex.transport.imap.ImapLine;

public class ImapCommandCapability
extends ImapCommand {
    private String addCapability(String fullCap, String cap) throws ImapException {
        Object t = fullCap;
        if (cap.indexOf(61) == -1) {
            t = (String)t + " " + cap;
        } else {
            String[] v = cap.split("=");
            if (v.length != 2) {
                throw new ImapException(null, "got illegal capability \"" + cap + "\" from command");
            }
            t = ((String)t).indexOf(v[0] + "=") > -1 ? ((String)t).replace(v[0] + "=", v[0] + "=" + v[1] + ",") : (String)t + " " + cap;
        }
        return t;
    }

    @Override
    public String[] processCommand(ImapLine line) throws ImapException {
        line.skipWhitespace(-1);
        if (!line.skipLineEnd()) {
            throw new ImapException(line, "error parsing command");
        }
        ImapCommand[] arr = ImapCommandFactory.getCommands();
        String cap = "";
        for (ImapCommand ic : arr) {
            String[] arr2 = ic.getCapabilities(line.getConnection());
            if (arr2 == null) continue;
            for (String a2 : arr2) {
                cap = this.addCapability(cap, a2);
            }
        }
        return new String[]{"* CAPABILITY IMAP4rev1" + cap + "\r\n", line.getTag() + " OK\r\n"};
    }

    @Override
    public String[] getCommandIdentifier() {
        return new String[]{"CAPABILITY"};
    }

    @Override
    public String[] getCapabilities(ImapConnection conn) {
        return new String[0];
    }
}

