/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.UsagePeriod;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class PayloadChunk
extends AbstractBlock
implements Serializable {
    public static final long serialVersionUID = 100000000013L;
    public static final int MIN_VALID_ID = 100;
    int id = 0;
    byte[] payload = null;
    PayloadType payloadType = PayloadType.PAYLOAD;
    UsagePeriod period;

    public PayloadChunk() {
        this.id = 0;
        this.payload = new byte[0];
        this.payloadType = PayloadType.PAYLOAD;
        this.period = new UsagePeriod(86400L);
    }

    public PayloadChunk(ASN1Encodable to, UsagePeriod period) throws IOException {
        this.parse(to);
        this.period = period;
    }

    public PayloadChunk(int id, byte[] payload, UsagePeriod period) {
        this.setId(id);
        this.setPayload(payload);
        this.period = period;
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.id < 100) {
            throw new IOException("illegal dump id is set");
        }
        v.add(new ASN1Integer(this.id));
        if (this.payloadType == PayloadType.PAYLOAD) {
            v.add(new DERTaggedObject(true, PayloadType.PAYLOAD.getId(), (ASN1Encodable)new DEROctetString(this.payload)));
        } else if (this.payloadType == PayloadType.REPLY) {
            v.add(new DERTaggedObject(true, PayloadType.REPLY.getId(), (ASN1Encodable)new DEROctetString(this.payload)));
        } else {
            throw new IOException("unable to dump payload block as payload and reply are empty");
        }
        return new DERSequence(v);
    }

    public final byte[] setPayload(byte[] b) {
        byte[] opl = this.payload;
        this.payload = (byte[])(b != null ? Arrays.copyOf(b, b.length) : null);
        this.payloadType = PayloadType.PAYLOAD;
        return opl;
    }

    public final byte[] getPayload() {
        if (this.payloadType != PayloadType.PAYLOAD) {
            return null;
        }
        if (this.payload == null) {
            return null;
        }
        return (byte[])this.payload.clone();
    }

    public final byte[] setReplyBlock(byte[] reply) {
        byte[] opl = this.payload;
        this.payload = Arrays.copyOf(reply, reply.length);
        this.payloadType = PayloadType.REPLY;
        return opl;
    }

    public final byte[] getReplyBlock() {
        if (this.payloadType != PayloadType.REPLY) {
            return null;
        }
        return (byte[])this.payload.clone();
    }

    public final UsagePeriod getUsagePeriod() {
        return this.period;
    }

    public final UsagePeriod setUsagePeriod(UsagePeriod period) {
        UsagePeriod ret = this.period;
        this.period = period;
        return ret;
    }

    @Override
    protected final void parse(ASN1Encodable to) throws IOException {
        ASN1TaggedObject dto;
        ASN1Sequence s1 = ASN1Sequence.getInstance(to);
        int i2 = 0;
        this.id = ASN1Integer.getInstance(s1.getObjectAt(i2++)).getValue().intValue();
        if ((dto = ASN1TaggedObject.getInstance(s1.getObjectAt(i2++))).getTagNo() == PayloadType.PAYLOAD.getId()) {
            this.setPayload(ASN1OctetString.getInstance(dto.getBaseObject()).getOctets());
        } else if (dto.getTagNo() == PayloadType.REPLY.getId()) {
            this.setReplyBlock(ASN1OctetString.getInstance(dto.getBaseObject()).getOctets());
        } else {
            throw new IOException("got bad tag number (expected:" + PayloadType.REPLY.getId() + " or " + PayloadType.PAYLOAD.getId() + ";got:" + dto.getTagNo() + ")");
        }
    }

    public final int setId(int id) {
        int ret = this.id;
        this.id = id;
        return ret;
    }

    public final int getId() {
        return this.id;
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumpType) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(" {").append("\r\n");
        sb.append(prefix).append("  id ").append(this.id).append(',').append("\r\n");
        sb.append(prefix).append("  content ");
        if (this.payloadType == PayloadType.PAYLOAD) {
            sb.append("payload ").append(PayloadChunk.toHex(this.payload)).append("\r\n");
        } else if (this.payloadType == PayloadType.REPLY) {
            sb.append("reply ").append(PayloadChunk.toHex(this.payload)).append("\r\n");
        } else {
            throw new IOException("unable to determine payload type (expected:" + PayloadType.REPLY.getId() + " or " + PayloadType.PAYLOAD.getId() + ";got:" + String.valueOf((Object)this.payloadType) + ")");
        }
        sb.append(prefix).append('}');
        return sb.toString();
    }

    public boolean isInUsagePeriod() {
        return this.isInUsagePeriod(new Date());
    }

    public boolean isInUsagePeriod(Date reference) {
        if (this.period == null) {
            return true;
        }
        return this.period.inUsagePeriod(reference);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        PayloadChunk pl = (PayloadChunk)o;
        try {
            return this.dumpValueNotation("", DumpType.ALL_UNENCRYPTED).equals(pl.dumpValueNotation("", DumpType.ALL_UNENCRYPTED));
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.dumpValueNotation("", DumpType.ALL_UNENCRYPTED).hashCode();
        }
        catch (IOException ioe) {
            return 0;
        }
    }

    private static enum PayloadType {
        PAYLOAD(100),
        REPLY(101);

        private final int id;

        private PayloadType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

