/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.server;

import com.icegreen.greenmail.server.ProtocolHandler;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSocketProtocolHandler
implements ProtocolHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Socket socket;
    protected volatile boolean quitting = false;
    protected final Object closeMonitor = new Object();

    protected AbstractSocketProtocolHandler(Socket socket) {
        this.socket = socket;
    }

    public boolean isQuitting() {
        return this.quitting;
    }

    public void setQuitting(boolean quitting) {
        this.quitting = quitting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.setQuitting(true);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Closing handler connection {}:{}", (Object)this.socket.getInetAddress(), (Object)this.socket.getPort());
        }
        Object object = this.closeMonitor;
        synchronized (object) {
            if (!this.socket.isClosed()) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    this.log.warn("Can not close socket", e);
                }
            }
        }
    }

    protected long getSoTimeout() {
        try {
            return this.socket.getSoTimeout();
        }
        catch (SocketException e) {
            this.log.warn("Can not get socket timeout", e);
            return -1L;
        }
    }
}

