/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.jctools.queues;

import com.hazelcast.shaded.org.jctools.queues.IndexedQueueSizeUtil;
import com.hazelcast.shaded.org.jctools.queues.MessagePassingQueue;
import com.hazelcast.shaded.org.jctools.queues.MessagePassingQueueUtil;
import com.hazelcast.shaded.org.jctools.queues.MpUnboundedXaddArrayQueuePad5;
import com.hazelcast.shaded.org.jctools.queues.MpUnboundedXaddChunk;
import com.hazelcast.shaded.org.jctools.queues.QueueProgressIndicators;
import com.hazelcast.shaded.org.jctools.queues.SpscArrayQueue;
import com.hazelcast.shaded.org.jctools.util.PortableJvmInfo;
import com.hazelcast.shaded.org.jctools.util.Pow2;
import com.hazelcast.shaded.org.jctools.util.UnsafeAccess;
import java.util.Iterator;

abstract class MpUnboundedXaddArrayQueue<R extends MpUnboundedXaddChunk<R, E>, E>
extends MpUnboundedXaddArrayQueuePad5<R, E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    private static final long ROTATION = -2L;
    final int chunkMask;
    final int chunkShift;
    final int maxPooledChunks;
    final SpscArrayQueue<R> freeChunksPool;

    MpUnboundedXaddArrayQueue(int chunkSize, int maxPooledChunks) {
        if (!UnsafeAccess.SUPPORTS_GET_AND_ADD_LONG) {
            throw new IllegalStateException("Unsafe::getAndAddLong support (JDK 8+) is required for this queue to work");
        }
        if (maxPooledChunks < 0) {
            throw new IllegalArgumentException("Expecting a positive maxPooledChunks, but got:" + maxPooledChunks);
        }
        chunkSize = Pow2.roundToPowerOfTwo(chunkSize);
        this.chunkMask = chunkSize - 1;
        this.chunkShift = Integer.numberOfTrailingZeros(chunkSize);
        this.freeChunksPool = new SpscArrayQueue(maxPooledChunks);
        Object first = this.newChunk(0L, null, chunkSize, maxPooledChunks > 0);
        this.soProducerChunk(first);
        this.soProducerChunkIndex(0L);
        this.soConsumerChunk(first);
        for (int i2 = 1; i2 < maxPooledChunks; ++i2) {
            this.freeChunksPool.offer((R)this.newChunk(-1L, null, chunkSize, true));
        }
        this.maxPooledChunks = maxPooledChunks;
    }

    public final int chunkSize() {
        return this.chunkMask + 1;
    }

    public final int maxPooledChunks() {
        return this.maxPooledChunks;
    }

    abstract R newChunk(long var1, R var3, int var4, boolean var5);

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    final R producerChunkForIndex(R initialChunk, long requiredChunkIndex) {
        long jumpBackward;
        Object currentChunk = initialChunk;
        while (true) {
            if (currentChunk == null) {
                currentChunk = this.lvProducerChunk();
            }
            long currentChunkIndex = ((MpUnboundedXaddChunk)currentChunk).lvIndex();
            assert (currentChunkIndex != -1L);
            jumpBackward = currentChunkIndex - requiredChunkIndex;
            if (jumpBackward >= 0L) break;
            if (this.lvProducerChunkIndex() == currentChunkIndex) {
                currentChunk = this.appendNextChunks(currentChunk, currentChunkIndex, -jumpBackward);
                continue;
            }
            currentChunk = null;
        }
        for (long i2 = 0L; i2 < jumpBackward; ++i2) {
            currentChunk = (MpUnboundedXaddChunk)((MpUnboundedXaddChunk)currentChunk).lvPrev();
            assert (currentChunk != null);
        }
        assert (((MpUnboundedXaddChunk)currentChunk).lvIndex() == requiredChunkIndex);
        return currentChunk;
    }

    protected final R appendNextChunks(R currentChunk, long currentChunkIndex, long chunksToAppend) {
        assert (currentChunkIndex != -1L);
        if (!this.casProducerChunkIndex(currentChunkIndex, -2L)) {
            return null;
        }
        assert (currentChunkIndex == ((MpUnboundedXaddChunk)currentChunk).lvIndex());
        for (long i2 = 1L; i2 <= chunksToAppend; ++i2) {
            R newChunk = this.newOrPooledChunk(currentChunk, currentChunkIndex + i2);
            this.soProducerChunk(newChunk);
            ((MpUnboundedXaddChunk)currentChunk).soNext(newChunk);
            currentChunk = newChunk;
        }
        this.soProducerChunkIndex(currentChunkIndex + chunksToAppend);
        return currentChunk;
    }

    private R newOrPooledChunk(R prevChunk, long nextChunkIndex) {
        MpUnboundedXaddChunk newChunk = (MpUnboundedXaddChunk)this.freeChunksPool.poll();
        if (newChunk != null) {
            assert (newChunk.lvIndex() < ((MpUnboundedXaddChunk)prevChunk).lvIndex());
            newChunk.soPrev(prevChunk);
            newChunk.soIndex(nextChunkIndex);
        } else {
            newChunk = this.newChunk(nextChunkIndex, prevChunk, this.chunkMask + 1, false);
        }
        return (R)newChunk;
    }

    final void moveToNextConsumerChunk(R cChunk, R next) {
        ((MpUnboundedXaddChunk)cChunk).soNext(null);
        ((MpUnboundedXaddChunk)next).soPrev(null);
        if (((MpUnboundedXaddChunk)cChunk).isPooled()) {
            boolean pooled = this.freeChunksPool.offer((R)cChunk);
            assert (pooled);
        }
        this.soConsumerChunk(next);
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return IndexedQueueSizeUtil.size(this, 1);
    }

    @Override
    public boolean isEmpty() {
        return IndexedQueueSizeUtil.isEmpty(this);
    }

    @Override
    public int capacity() {
        return -1;
    }

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return MessagePassingQueueUtil.drain(this, c);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        int chunkCapacity = this.chunkMask + 1;
        int offerBatch = Math.min(PortableJvmInfo.RECOMENDED_OFFER_BATCH, chunkCapacity);
        return MessagePassingQueueUtil.fillInBatchesToLimit(this, s, offerBatch, chunkCapacity);
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        return MessagePassingQueueUtil.drain(this, c, limit);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        MessagePassingQueueUtil.drain(this, c, wait, exit);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        MessagePassingQueueUtil.fill(this, s, wait, exit);
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }
}

