/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.iteration.IndexIterationPointer;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.impl.Comparison;
import com.hazelcast.query.impl.GlobalIndexPartitionTracker;
import com.hazelcast.query.impl.IndexKeyEntries;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.sql.impl.QueryException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class MapFetchIndexOperation
extends MapOperation
implements ReadonlyOperation {
    private String indexName;
    private PartitionIdSet partitionIdSet;
    private IndexIterationPointer[] pointers;
    private int sizeLimit;
    private transient MapFetchIndexOperationResult response;

    public MapFetchIndexOperation() {
    }

    public MapFetchIndexOperation(String mapName, String indexName, IndexIterationPointer[] pointers, PartitionIdSet partitionIdSet, int sizeLimit) {
        super(mapName);
        Preconditions.checkPositive(sizeLimit, "" + sizeLimit);
        this.indexName = indexName;
        this.partitionIdSet = partitionIdSet;
        this.pointers = pointers;
        this.sizeLimit = sizeLimit;
    }

    @Override
    protected void runInternal() {
        InternalIndex index = MapFetchIndexOperation.getInternalIndex(this.mapContainer, this.name, this.indexName);
        GlobalIndexPartitionTracker.PartitionStamp indexStamp = index.getPartitionStamp();
        if (indexStamp == null) {
            throw new RetryableHazelcastException("Index is being rebuilt");
        }
        if (indexStamp.partitions.equals(this.partitionIdSet)) {
            this.partitionIdSet = null;
        } else if (!indexStamp.partitions.containsAll(this.partitionIdSet)) {
            throw new MissingPartitionException("some requested partitions are not indexed");
        }
        switch (index.getConfig().getType()) {
            case HASH: {
                this.response = this.runInternalHash(index);
                break;
            }
            case SORTED: {
                this.response = this.runInternalSorted(index);
                break;
            }
            case BITMAP: {
                throw new UnsupportedOperationException("BITMAP index scan is not implemented");
            }
            default: {
                throw new UnsupportedOperationException("Unknown index type: \"" + index.getConfig().getType().name() + "\"");
            }
        }
        if (!index.validatePartitionStamp(indexStamp.stamp)) {
            throw new MissingPartitionException("partition timestamp has changed");
        }
    }

    @Nonnull
    public static InternalIndex getInternalIndex(@Nonnull MapContainer mapContainer, @Nonnull String mapName, @Nonnull String indexName) {
        if (!mapContainer.shouldUseGlobalIndex()) {
            throw QueryException.error(1009, "Cannot use the index \"" + indexName + "\" of the IMap \"" + mapName + "\" because it is not global (make sure the property \"" + ClusterProperty.GLOBAL_HD_INDEX_ENABLED + "\" is set to \"true\")");
        }
        InternalIndex index = mapContainer.getGlobalIndexRegistry().getIndex(indexName);
        if (index == null) {
            throw QueryException.error(1009, "Index \"" + indexName + "\" does not exist");
        }
        return index;
    }

    private MapFetchIndexOperationResult runInternalSorted(InternalIndex index) {
        ArrayList entries = new ArrayList(this.sizeLimit);
        int partitionCount = this.getNodeEngine().getPartitionService().getPartitionCount();
        ILogger logger = this.logger();
        for (int i2 = 0; i2 < this.pointers.length; ++i2) {
            IndexIterationPointer pointer = this.pointers[i2];
            Data lastEntryKeyData = pointer.getLastEntryKeyData();
            if (logger.isFinestEnabled()) {
                logger.finest("Processing pointer: " + pointer);
            }
            Iterator<IndexKeyEntries> entryIterator = MapFetchIndexOperation.getEntryIterator(index, pointer);
            while (entryIterator.hasNext()) {
                IndexIterationPointer[] newPointers;
                IndexKeyEntries indexKeyEntries = entryIterator.next();
                Iterator<QueryableEntry> keyEntries = indexKeyEntries.getEntries();
                while (keyEntries.hasNext() && entries.size() < this.sizeLimit) {
                    QueryableEntry entry = keyEntries.next();
                    if (!MapFetchIndexOperation.isInPartitionSet(entry, this.partitionIdSet, partitionCount)) continue;
                    entries.add(entry);
                    lastEntryKeyData = entry.getKeyData();
                }
                boolean moreDataWithCurrentKey = keyEntries.hasNext();
                if (entries.size() < this.sizeLimit) continue;
                if (moreDataWithCurrentKey || entryIterator.hasNext()) {
                    Comparable<?> currentIndexKey = indexKeyEntries.getIndexKey();
                    newPointers = new IndexIterationPointer[this.pointers.length - i2];
                    newPointers[0] = IndexIterationPointer.create(pointer.isDescending() ? pointer.getFrom() : currentIndexKey, pointer.isDescending() ? pointer.isFromInclusive() : moreDataWithCurrentKey, pointer.isDescending() ? currentIndexKey : pointer.getTo(), pointer.isDescending() ? moreDataWithCurrentKey : pointer.isToInclusive(), pointer.isDescending(), moreDataWithCurrentKey ? lastEntryKeyData : null);
                    if (logger.isFinestEnabled()) {
                        logger.finest("Generated pointer: " + newPointers[0]);
                    }
                    System.arraycopy(this.pointers, i2 + 1, newPointers, 1, newPointers.length - 1);
                } else {
                    newPointers = new IndexIterationPointer[this.pointers.length - i2 - 1];
                    System.arraycopy(this.pointers, i2 + 1, newPointers, 0, newPointers.length);
                }
                return new MapFetchIndexOperationResult(entries, newPointers);
            }
        }
        return new MapFetchIndexOperationResult(entries, new IndexIterationPointer[0]);
    }

    private static Iterator<IndexKeyEntries> getEntryIterator(InternalIndex index, IndexIterationPointer pointer) {
        Iterator<IndexKeyEntries> entryIterator;
        if (pointer.getFrom() != null) {
            if (pointer.getTo() != null) {
                if (pointer.getFrom().compareTo(pointer.getTo()) == 0) {
                    assert (pointer.isFromInclusive() && pointer.isToInclusive()) : "If range scan is a point lookup then limits should be all inclusive";
                    entryIterator = index.getSqlRecordIteratorBatch(pointer.getFrom(), pointer.isDescending(), pointer.getLastEntryKeyData());
                } else {
                    entryIterator = index.getSqlRecordIteratorBatch(pointer.getFrom(), pointer.isFromInclusive(), pointer.getTo(), pointer.isToInclusive(), pointer.isDescending(), pointer.getLastEntryKeyData());
                }
            } else {
                entryIterator = index.getSqlRecordIteratorBatch(pointer.isFromInclusive() ? Comparison.GREATER_OR_EQUAL : Comparison.GREATER, pointer.getFrom(), pointer.isDescending(), pointer.getLastEntryKeyData());
            }
        } else {
            entryIterator = pointer.getTo() != null ? index.getSqlRecordIteratorBatch(pointer.isToInclusive() ? Comparison.LESS_OR_EQUAL : Comparison.LESS, pointer.getTo(), pointer.isDescending(), pointer.getLastEntryKeyData()) : index.getSqlRecordIteratorBatch(pointer.isDescending());
        }
        return entryIterator;
    }

    private MapFetchIndexOperationResult runInternalHash(InternalIndex index) {
        int pointerIndex;
        ArrayList entries = new ArrayList(this.sizeLimit);
        int partitionCount = this.getNodeEngine().getPartitionService().getPartitionCount();
        for (pointerIndex = 0; pointerIndex < this.pointers.length && entries.size() < this.sizeLimit; ++pointerIndex) {
            IndexIterationPointer pointer = this.pointers[pointerIndex];
            assert (pointer.getFrom() == pointer.getTo()) : "Unordered index iteration pointer must have same from and to values";
            Set<QueryableEntry> keyEntries = index.getRecords(pointer.getFrom());
            if (this.partitionIdSet == null) {
                entries.addAll(keyEntries);
                continue;
            }
            for (QueryableEntry entry : keyEntries) {
                if (!MapFetchIndexOperation.isInPartitionSet(entry, this.partitionIdSet, partitionCount)) continue;
                entries.add(entry);
            }
        }
        IndexIterationPointer[] newPointers = new IndexIterationPointer[this.pointers.length - pointerIndex];
        System.arraycopy(this.pointers, pointerIndex, newPointers, 0, newPointers.length);
        return new MapFetchIndexOperationResult(entries, newPointers);
    }

    private static boolean isInPartitionSet(QueryableEntry entry, PartitionIdSet partitionIdSet, int partitionCount) {
        if (partitionIdSet == null) {
            return true;
        }
        int partitionId = HashUtil.hashToIndex(entry.getKeyData().getPartitionHash(), partitionCount);
        return partitionIdSet.contains(partitionId);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void assertNativeMapOnPartitionThread() {
    }

    @Override
    public void logError(Throwable e) {
        if (!(e instanceof MissingPartitionException)) {
            super.logError(e);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.indexName = in.readString();
        this.partitionIdSet = (PartitionIdSet)in.readObject();
        int pointersLength = in.readInt();
        this.pointers = new IndexIterationPointer[pointersLength];
        for (int i2 = 0; i2 < pointersLength; ++i2) {
            this.pointers[i2] = (IndexIterationPointer)in.readObject();
        }
        this.sizeLimit = in.readInt();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeString(this.indexName);
        out.writeObject(this.partitionIdSet);
        out.writeInt(this.pointers.length);
        for (IndexIterationPointer pointer : this.pointers) {
            out.writeObject(pointer);
        }
        out.writeInt(this.sizeLimit);
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 155;
    }

    public static final class MissingPartitionException
    extends HazelcastException {
        public MissingPartitionException(String message) {
            super(message);
        }

        public MissingPartitionException(String message, Throwable t) {
            super(message, t);
        }
    }

    public static final class MapFetchIndexOperationResult
    implements IdentifiedDataSerializable {
        private List<QueryableEntry<?, ?>> entries;
        private IndexIterationPointer[] pointers;

        public MapFetchIndexOperationResult() {
        }

        public MapFetchIndexOperationResult(List<QueryableEntry<?, ?>> entries, IndexIterationPointer[] pointers) {
            this.entries = entries;
            this.pointers = pointers;
        }

        public List<QueryableEntry<?, ?>> getEntries() {
            return this.entries;
        }

        public IndexIterationPointer[] getPointers() {
            return this.pointers;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            SerializationUtil.writeList(this.entries, out);
            out.writeInt(this.pointers.length);
            for (IndexIterationPointer pointer : this.pointers) {
                out.writeObject(pointer);
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.entries = SerializationUtil.readList(in);
            int len = in.readInt();
            this.pointers = new IndexIterationPointer[len];
            for (int i2 = 0; i2 < len; ++i2) {
                this.pointers[i2] = (IndexIterationPointer)in.readObject();
            }
        }

        @Override
        public int getFactoryId() {
            return MapDataSerializerHook.F_ID;
        }

        @Override
        public int getClassId() {
            return 157;
        }
    }
}

