/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.serialization.impl.FieldOperations;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.RabinFingerprint;
import com.hazelcast.internal.serialization.impl.compact.schema.SchemaDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Schema
implements IdentifiedDataSerializable {
    private String typeName;
    private Map<String, FieldDescriptor> fieldsMap;
    private List<FieldDescriptor> fields;
    private int numberVarSizeFields;
    private int fixedSizeFieldsLength;
    private transient long schemaId;

    public Schema() {
    }

    public Schema(String typeName, List<FieldDescriptor> fields) {
        this.typeName = typeName;
        this.fields = fields;
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    private void init() {
        void var6_10;
        HashMap<String, FieldDescriptor> fieldsMap = new HashMap<String, FieldDescriptor>(this.fields.size());
        for (FieldDescriptor field : this.fields) {
            fieldsMap.put(field.getFieldName(), field);
        }
        this.fieldsMap = fieldsMap;
        this.fields.sort(Comparator.comparing(FieldDescriptor::getFieldName));
        ArrayList<Object> fixedSizeFields = new ArrayList<Object>();
        ArrayList<FieldDescriptor> booleanFields = new ArrayList<FieldDescriptor>();
        ArrayList<FieldDescriptor> variableSizeFields = new ArrayList<FieldDescriptor>();
        for (FieldDescriptor fieldDescriptor : this.fields) {
            FieldKind fieldKind = fieldDescriptor.getKind();
            if (FieldOperations.fieldOperations(fieldKind).kindSizeInBytes() == -1) {
                variableSizeFields.add(fieldDescriptor);
                continue;
            }
            if (FieldKind.BOOLEAN == fieldKind) {
                booleanFields.add(fieldDescriptor);
                continue;
            }
            fixedSizeFields.add(fieldDescriptor);
        }
        fixedSizeFields.sort(Comparator.comparingInt(d -> FieldOperations.fieldOperations(((FieldDescriptor)d).getKind()).kindSizeInBytes()).reversed());
        int offset = 0;
        for (Object descriptor : fixedSizeFields) {
            ((FieldDescriptor)descriptor).setOffset(offset);
            offset += FieldOperations.fieldOperations(((FieldDescriptor)descriptor).getKind()).kindSizeInBytes();
        }
        boolean bl = false;
        for (FieldDescriptor fieldDescriptor : booleanFields) {
            fieldDescriptor.setOffset(offset);
            fieldDescriptor.setBitOffset((byte)(var6_10 % 8));
            if (++var6_10 % 8 != false) continue;
            ++offset;
        }
        if (var6_10 % 8 != false) {
            ++offset;
        }
        this.fixedSizeFieldsLength = offset;
        int index = 0;
        for (FieldDescriptor fieldDescriptor : variableSizeFields) {
            fieldDescriptor.setIndex(index++);
        }
        this.numberVarSizeFields = index;
        this.schemaId = RabinFingerprint.fingerprint64(this);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Collection<FieldDescriptor> getFields() {
        return this.fields;
    }

    public Set<String> getFieldNames() {
        return this.fieldsMap.keySet();
    }

    public int getNumberOfVariableSizeFields() {
        return this.numberVarSizeFields;
    }

    public int getFixedSizeFieldsLength() {
        return this.fixedSizeFieldsLength;
    }

    public int getFieldCount() {
        return this.fieldsMap.size();
    }

    public FieldDescriptor getField(String fieldName) {
        return this.fieldsMap.get(fieldName);
    }

    public boolean hasField(String fieldName) {
        return this.fieldsMap.containsKey(fieldName);
    }

    public long getSchemaId() {
        return this.schemaId;
    }

    public String toString() {
        return "Schema { className = " + this.typeName + ", numberOfComplexFields = " + this.numberVarSizeFields + ", primitivesLength = " + this.fixedSizeFieldsLength + ", map = " + this.fieldsMap + "}";
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.typeName);
        out.writeInt(this.fields.size());
        for (FieldDescriptor descriptor : this.fields) {
            out.writeString(descriptor.getFieldName());
            out.writeInt(descriptor.getKind().getId());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.typeName = in.readString();
        int fieldCount = in.readInt();
        this.fields = new ArrayList<FieldDescriptor>(fieldCount);
        for (int i2 = 0; i2 < fieldCount; ++i2) {
            String name = in.readString();
            FieldKind kind = FieldKind.get(in.readInt());
            FieldDescriptor descriptor = new FieldDescriptor(name, kind);
            this.fields.add(descriptor);
        }
        this.init();
    }

    public static List<Schema> readSchemas(DataInput in) throws IOException {
        int schemaCount = in.readInt();
        ArrayList<Schema> schemas = new ArrayList<Schema>(schemaCount);
        for (int i2 = 0; i2 < schemaCount; ++i2) {
            String typeName = in.readUTF();
            int fieldCount = in.readInt();
            ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>(fieldCount);
            for (int j = 0; j < fieldCount; ++j) {
                String name = in.readUTF();
                FieldKind kind = FieldKind.get(in.readInt());
                FieldDescriptor descriptor = new FieldDescriptor(name, kind);
                fields.add(descriptor);
            }
            Schema schema = new Schema(typeName, fields);
            schemas.add(schema);
        }
        return schemas;
    }

    public static void writeSchemas(DataOutput out, Collection<Schema> schemas) throws IOException {
        out.writeInt(schemas.size());
        for (Schema schema : schemas) {
            out.writeUTF(schema.getTypeName());
            out.writeInt(schema.getFieldCount());
            for (FieldDescriptor descriptor : schema.getFields()) {
                out.writeUTF(descriptor.getFieldName());
                out.writeInt(descriptor.getKind().getId());
            }
        }
    }

    @Override
    public int getFactoryId() {
        return SchemaDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema = (Schema)o;
        return this.numberVarSizeFields == schema.numberVarSizeFields && this.fixedSizeFieldsLength == schema.fixedSizeFieldsLength && this.schemaId == schema.schemaId && Objects.equals(this.typeName, schema.typeName) && Objects.equals(this.fields, schema.fields) && Objects.equals(this.fieldsMap, schema.fieldsMap);
    }

    public int hashCode() {
        return (int)this.schemaId;
    }
}

