/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.longregister.operations;

import com.hazelcast.internal.longregister.LongRegister;
import com.hazelcast.internal.longregister.LongRegisterService;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.Map;

public class LongRegisterReplicationOperation
extends Operation
implements IdentifiedDataSerializable {
    private Map<String, Long> migrationData;

    public LongRegisterReplicationOperation() {
    }

    public LongRegisterReplicationOperation(Map<String, Long> migrationData) {
        this.migrationData = migrationData;
    }

    @Override
    public void run() throws Exception {
        LongRegisterService longRegisterService = (LongRegisterService)this.getService();
        for (Map.Entry<String, Long> longEntry : this.migrationData.entrySet()) {
            String name = longEntry.getKey();
            LongRegister container = longRegisterService.getLongRegister(name);
            Long value = longEntry.getValue();
            container.set(value);
        }
    }

    @Override
    public String getServiceName() {
        return "hz:impl:atomicLongService";
    }

    @Override
    public int getFactoryId() {
        return -999999999;
    }

    @Override
    public int getClassId() {
        return 7;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.migrationData.size());
        for (Map.Entry<String, Long> entry : this.migrationData.entrySet()) {
            out.writeString(entry.getKey());
            out.writeLong(entry.getValue());
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int mapSize = in.readInt();
        this.migrationData = MapUtil.createHashMap(mapSize);
        for (int i2 = 0; i2 < mapSize; ++i2) {
            String name = in.readString();
            Long longContainer = in.readLong();
            this.migrationData.put(name, longContainer);
        }
    }
}

