/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.router.operation;

import java.util.LinkedHashMap;
import java.util.Map;
import net.messagevortex.router.operation.BitShifter;
import net.messagevortex.router.operation.MathMode;

public class GaloisFieldMathMode
implements MathMode {
    private final int gfFieldSize;
    private final int omega;
    private final int[] gfLog;
    private final int[] gfInverseLog;
    static final int[] PRIM_POLYNOM = new int[]{3, 7, 11, 19, 37, 67, 131, 285, 529, 1033, 2053, 4179, 8219, 17475, 32771, 65581, 0, 0, 0, 0, 0, 0, 0, 16777351};
    static final Map<Integer, GaloisFieldMathMode> cachedMathMode = new LinkedHashMap<Integer, GaloisFieldMathMode>();

    public GaloisFieldMathMode(int omega) {
        if (omega < 2 || omega > 32 || PRIM_POLYNOM[omega - 1] == 0) {
            throw new ArithmeticException("illegal GF size " + omega + " (PRIM_POLYNOM unknown)");
        }
        this.omega = omega;
        this.gfFieldSize = (int)Math.pow(2.0, omega);
        this.gfLog = new int[this.gfFieldSize];
        this.gfInverseLog = new int[this.gfFieldSize];
        int b = 1;
        for (int log = 0; log < this.gfFieldSize - 1; ++log) {
            this.gfLog[b % this.gfFieldSize] = log;
            this.gfInverseLog[log % this.gfFieldSize] = b;
            if (((b = BitShifter.lshift(b, 1, (byte)33)) & this.gfFieldSize) == 0) continue;
            b ^= PRIM_POLYNOM[omega - 1];
        }
        this.gfLog[0] = -1;
        this.gfInverseLog[this.gfFieldSize - 1] = -1;
    }

    public static GaloisFieldMathMode getGaloisFieldMathMode(int omega) {
        if (omega < 1 || omega > 16) {
            throw new IllegalArgumentException("omega (" + omega + ") out of range 1..16");
        }
        GaloisFieldMathMode ret = cachedMathMode.get(omega);
        if (ret == null) {
            ret = new GaloisFieldMathMode(omega);
            while (cachedMathMode.size() > 50) {
                cachedMathMode.remove(cachedMathMode.keySet().iterator().next());
            }
            cachedMathMode.put(omega, ret);
        }
        return ret;
    }

    @Override
    public int mul(int c1, int c2) {
        if (c1 == 0 || c2 == 0) {
            return 0;
        }
        int sumLog = this.gfLog[c1] + this.gfLog[c2];
        if (sumLog >= this.gfFieldSize - 1) {
            sumLog -= this.gfFieldSize - 1;
        }
        return this.gfInverseLog[sumLog];
    }

    @Override
    public int div(int c1, int divisor) {
        int diffLog;
        if (c1 == 0) {
            return 0;
        }
        if (divisor == 0) {
            throw new ArithmeticException("Divisionby 0");
        }
        for (diffLog = this.gfLog[c1] - this.gfLog[divisor]; diffLog < 0; diffLog += this.gfFieldSize - 1) {
        }
        return this.gfInverseLog[diffLog];
    }

    @Override
    public int add(int c1, int c2) {
        return c1 ^ c2;
    }

    @Override
    public int sub(int c1, int c2) {
        return this.add(c1, c2);
    }

    public int[] getGfLog() {
        return (int[])this.gfLog.clone();
    }

    public int[] getGfIlog() {
        return (int[])this.gfInverseLog.clone();
    }

    @Override
    public String toString() {
        return "GF(2^" + this.omega + ")";
    }

    public String getTableDump() {
        int x;
        StringBuilder sb = new StringBuilder();
        sb.append("omega=").append(this.omega).append(System.lineSeparator());
        sb.append("Add:xor; sub=xor; ").append(System.lineSeparator());
        sb.append("mul=iif (c1 == 0 || c2 == 0;0; gfilog[gfLog[c1] + gfLog[c2]-iif(gfLog[c1] + ").append("gfLog[c2]>2^").append(this.omega).append("-1;2^\"+omega+\"-1;0)]").append(System.lineSeparator());
        sb.append("div=iif (c1 == 0;0;iif(c2==0;illegal;gfilog[gfLog[c1] - gfLog[c2]+iif(").append("gfLog[c1] - gfLog[c2]<>0;2^\"+omega+\"-1;0))]").append(System.lineSeparator());
        sb.append(System.lineSeparator());
        int cols = (int)Math.ceil(Math.sqrt(Math.pow(2.0, this.omega)) / 2.0);
        for (x = 0; x < cols; ++x) {
            sb.append("| num | log   | ilog  |  ");
        }
        sb.append(System.lineSeparator());
        for (x = 0; x < cols; ++x) {
            sb.append("+-----+-------+-------+  ");
        }
        sb.append(System.lineSeparator());
        int rows = (int)Math.ceil(Math.pow(2.0, this.omega) / (double)cols);
        for (int y = 0; y < rows; ++y) {
            for (int x2 = 0; x2 < cols; ++x2) {
                int i = x2 * rows + y;
                if (!((double)i < Math.pow(2.0, this.omega))) continue;
                sb.append(String.format("| %3d | %5d | %5d |  ", i, this.gfLog[i], this.gfInverseLog[i]));
            }
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }
}

