/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1.encryption;

public enum CipherUsage {
    SIGN(200, "sign"),
    ENCRYPT(210, "encrypt");

    private final int id;
    private final String txt;

    private CipherUsage(int id, String txt) {
        this.id = id;
        this.txt = txt;
    }

    public int getId() {
        return this.id;
    }

    public String getUsageString() {
        return this.txt;
    }

    public static CipherUsage getByString(String name) {
        if (name == null) {
            return null;
        }
        for (CipherUsage e : CipherUsage.values()) {
            if (!e.txt.equals(name.toLowerCase())) continue;
            return e;
        }
        return null;
    }

    public static CipherUsage getById(int id) {
        for (CipherUsage e : CipherUsage.values()) {
            if (e.id != id) continue;
            return e;
        }
        return null;
    }
}

