/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import net.messagevortex.Config;
import net.messagevortex.MessageVortexConfig;
import net.messagevortex.MessageVortexController;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.MessageVortexRepository;
import net.messagevortex.RunningDaemon;
import net.messagevortex.ThreadDumper;
import net.messagevortex.Version;
import net.messagevortex.accounting.Accountant;
import net.messagevortex.asn1.AsymmetricKeyPreCalculator;
import net.messagevortex.asn1.IdentityStore;
import net.messagevortex.blender.Blender;
import net.messagevortex.blender.recipes.BlenderRecipe;
import net.messagevortex.commandline.CommandLineHandlerCipher;
import net.messagevortex.commandline.CommandLineHandlerExamples;
import net.messagevortex.commandline.CommandLineHandlerIdentityStore;
import net.messagevortex.commandline.CommandLineHandlerInit;
import net.messagevortex.commandline.CommandLineHandlerRedundancy;
import net.messagevortex.commandline.CommandLineHandlerVersion;
import net.messagevortex.router.Router;
import net.messagevortex.transport.Transport;
import net.messagevortex.transport.dummy.DummyTransportTrx;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import picocli.CommandLine;

@CommandLine.Command(description={"A MessageVortex implementation for the privacy aware person."}, name="MessageVortex", mixinStandardHelpOptions=true, versionProvider=Version.class, subcommands={AsymmetricKeyPreCalculator.class, CommandLineHandlerIdentityStore.class, CommandLineHandlerCipher.class, CommandLineHandlerVersion.class, CommandLineHandlerInit.class, CommandLineHandlerRedundancy.class, CommandLineHandlerExamples.class})
public class MessageVortex
implements Callable<Integer> {
    public static final int CONFIG_FAIL = 101;
    public static final int SETUP_FAIL = 102;
    public static final int ARGUMENT_FAIL = 103;
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    @CommandLine.Option(names={"-c", "--config"}, description={"filename of the config to be used"})
    private String configFile = "messageVortex.cfg";
    @CommandLine.Option(names={"--timeoutAndDie"}, hidden=true, description={"timeout before aboorting execution (for test purposes only)"})
    private int timeoutInSeconds = -1;
    @CommandLine.Option(names={"--threadDumpInteval"}, hidden=true, description={"timeout before aboorting execution (for test purposes only)"})
    private int threadDumpInterval = 300;
    private static Integer JRE_AES_KEY_SIZE = null;

    private boolean verifyPrerequisites() {
        LOGGER.log(Level.INFO, "Checking bouncycastle version...");
        String bcversion = BouncyCastleProvider.class.getPackage().getImplementationVersion();
        LOGGER.log(Level.INFO, "Detected BouncyCastle version is " + bcversion);
        if (bcversion == null) {
            LOGGER.log(Level.SEVERE, "unable to determine BC version (got NULL value)");
            return false;
        }
        Matcher m = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(?:\\.(\\d+))?(beta(\\d*))?").matcher(bcversion);
        if (!m.matches()) {
            LOGGER.log(Level.SEVERE, "unable to parse BC version (" + bcversion + ")");
            return false;
        }
        int major = Integer.parseInt(m.group(1));
        int minor = Integer.parseInt(m.group(2));
        if ((major != 1 || minor < 60) && major < 2) {
            LOGGER.log(Level.SEVERE, "Looks like your BC installation is heavily outdated. At least version 1.60 is recommended.");
            return false;
        }
        LOGGER.log(Level.INFO, "Detected BC version is " + bcversion + ". This should do the trick.");
        LOGGER.log(Level.INFO, "Checking JRE");
        try {
            int i;
            String jreversion = System.getProperty("java.version");
            LOGGER.log(Level.INFO, "JRE  version is " + jreversion);
            if (JRE_AES_KEY_SIZE == null) {
                JRE_AES_KEY_SIZE = Cipher.getMaxAllowedKeyLength("AES");
            }
            if ((i = JRE_AES_KEY_SIZE.intValue()) <= 128) {
                LOGGER.log(Level.SEVERE, "Looks like JRE not having an unlimited JCE installed (AES max allowed key length is = " + i + "). This is bad.");
                return false;
            }
            LOGGER.log(Level.INFO, "Looks like JRE having an unlimited JCE installed (AES max allowed key length is = " + i + "). This is good.");
        }
        catch (NoSuchAlgorithmException nsa) {
            LOGGER.log(Level.SEVERE, "OOPS... Got an exception while testing for an unlimited JCE. This is bad.", nsa);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        int retval = MessageVortex.mainReturn(args);
        if (retval > 0) {
            System.exit(retval);
        }
    }

    public static int mainReturn(String[] args) {
        LOGGER.log(Level.INFO, "MessageVortex V" + Version.getBuild());
        CommandLine c = new CommandLine((Object)new MessageVortex());
        c.execute(args == null ? new String[]{} : args);
        Integer i = (Integer)c.getExecutionResult();
        return i != null ? i : 103;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Integer call() {
        LOGGER.log(Level.INFO, "******* startup of MessageVortex *******");
        try {
            LOGGER.log(Level.INFO, "Loading config file");
            MessageVortexConfig.getDefault().load(this.configFile);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Unable to parse config file", ioe);
            return 101;
        }
        try {
            void var4_9;
            this.verifyPrerequisites();
            Config cfg = MessageVortexConfig.getDefault();
            MessageVortexRepository.setIdentityStore("", "default_identity_store", new IdentityStore(new File("identityStore.cfg")));
            String[] stringArray = cfg.getSectionListValue(null, "identity_store_setup");
            int n = stringArray.length;
            boolean bl = false;
            while (var4_9 < n) {
                String idstoreSection = stringArray[var4_9];
                LOGGER.log(Level.INFO, "setting up identity store \"" + idstoreSection + "\"");
                String fn = cfg.getStringValue(idstoreSection, "filename");
                if (fn == null) {
                    throw new IOException("unable to obtain identity store filename of section " + idstoreSection);
                }
                File f = new File(fn);
                if (!f.exists()) {
                    throw new IOException("identity store file \"" + fn + "\" not found");
                }
                MessageVortexRepository.setIdentityStore("", idstoreSection.toLowerCase(), new IdentityStore(f));
                ++var4_9;
            }
            String lst = Config.getDefault().getStringValue(null, "recipes");
            BlenderRecipe.clearRecipes(null);
            for (String cl : lst.split(" *, *")) {
                BlenderRecipe.addRecipe(null, (BlenderRecipe)MessageVortex.getConfiguredClass(null, cl, BlenderRecipe.class));
            }
            for (String cl : cfg.getSectionListValue(null, "recipe_setup")) {
            }
            for (String accountingSection : cfg.getSectionListValue(null, "accountant_setup")) {
                LOGGER.log(Level.INFO, "setting up accounting for routing layer \"" + accountingSection + "\"");
                MessageVortexRepository.setAccountant("", accountingSection.toLowerCase(), (Accountant)MessageVortex.getDaemon(accountingSection, cfg.getStringValue(accountingSection, "accounting_implementation"), DaemonType.ACCOUNTING));
            }
            for (String routerSection : cfg.getSectionListValue(null, "router_setup")) {
                LOGGER.log(Level.INFO, "setting up routing layer \"" + routerSection + "\"");
                MessageVortexRepository.setRouter("", routerSection.toLowerCase(), (Router)MessageVortex.getDaemon(routerSection, cfg.getStringValue(routerSection, "router_implementation"), DaemonType.ROUTING));
            }
            for (String blendingSection : cfg.getSectionListValue(null, "blender_setup")) {
                LOGGER.log(Level.INFO, "setting up blending layer \"" + blendingSection + "\"");
                MessageVortexRepository.setBlender("", blendingSection.toLowerCase(), (Blender)MessageVortex.getDaemon(blendingSection, cfg.getStringValue(blendingSection, "blender_implementation"), DaemonType.BLEDING));
            }
            for (String transportSection : cfg.getSectionListValue(null, "transport_setup")) {
                LOGGER.log(Level.INFO, "setting up transport layer \"" + transportSection + "\"");
                MessageVortexRepository.setTransport("", transportSection.toLowerCase(), (Transport)MessageVortex.getDaemon(transportSection, cfg.getStringValue(transportSection, "transport_implementation"), DaemonType.TRANSPORT));
                LOGGER.log(Level.INFO, "  setting up of \"" + transportSection + "\" is done");
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Exception while setting up infrastructure", ioe);
            return 102;
        }
        catch (ClassNotFoundException cnf) {
            LOGGER.log(Level.SEVERE, "Bad class configured", cnf);
            return 102;
        }
        if (this.threadDumpInterval > 0) {
            LOGGER.log(Level.INFO, "starting thread dumper with interval " + this.threadDumpInterval);
            new ThreadDumper(this.threadDumpInterval);
        }
        LOGGER.log(Level.INFO, "******* startup of MessageVortex complete *******");
        MessageVortexController controller = new MessageVortexController();
        controller.setTimeout(this.timeoutInSeconds * 1000);
        controller.waitForShutdown();
        LOGGER.log(Level.INFO, "******* shutting down MessageVortex *******");
        Map<String, RunningDaemon> tmap = MessageVortexRepository.getRunningDaemons("");
        for (Map.Entry entry : tmap.entrySet()) {
            LOGGER.log(Level.INFO, "shutting down " + (String)entry.getKey());
            ((RunningDaemon)entry.getValue()).shutdownDaemon();
        }
        MessageVortexRepository.clear("");
        DummyTransportTrx.clearDummyEndpoints();
        LOGGER.log(Level.INFO, "******* shutdown complete *******");
        return 0;
    }

    public static RunningDaemon getDaemon(String section, String classname, DaemonType type) throws ClassNotFoundException {
        return (RunningDaemon)MessageVortex.getConfiguredClass(section, classname, RunningDaemon.class);
    }

    public static Object getConfiguredClass(String section, String name, Class templateClass) throws ClassNotFoundException {
        Constructor<?> myConstructor;
        if (name == null) {
            throw new ClassNotFoundException("unable to obtain class \"null\"");
        }
        Class<?> myClass = Class.forName(name);
        try {
            myConstructor = myClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new ClassNotFoundException("unable to get apropriate constructor from class \"" + name + "\"", e);
        }
        if (!templateClass.isAssignableFrom(myClass)) {
            throw new ClassNotFoundException("Class \"" + name + "\" does not implement required interfaces");
        }
        try {
            return myConstructor.newInstance(section);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ClassNotFoundException("Class \"" + name + "\" failed running the constructor", e);
        }
    }

    private static enum DaemonType {
        TRANSPORT,
        BLEDING,
        ROUTING,
        ACCOUNTING,
        IDENTITY_STORE;

    }
}

